import fs from "fs";
import path from "path";

const logDir = path.join(process.cwd(), "./src/logs");
const logFile = path.join(logDir, "alfresco-tagging.log");

if (!fs.existsSync(logDir)) {
  fs.mkdirSync(logDir, { recursive: true });
}

export const log = (message) => {
  const logMessage = `${new Date().toISOString()} - INFO: ${message}\n`;
  fs.appendFileSync(logFile, logMessage);
};

export const error = (message) => {
  const logMessage = `${new Date().toISOString()} - ERROR: ${message}\n`;
  fs.appendFileSync(logFile, logMessage);
};
